	% Example 8.8
	clear all
	clc 
	%  Synthesis of lowpass Lattice filters
	wc = 1;	ws = 1.42;	r = 0.15; Amax =-10*log10(1-r^2); Amin = 40;
	N = CA_ORDER_S(wc, ws, Amax, Amin)
	N = 5;		
	[G, Z, R_ZEROS, P, wsnew] = CA_POLES_S(wc, ws, Amax, Amin, N)	
	xmax = 1;	xmin = -2;	ymax = 2;
	
	figure(1)
	PLOT_PZ_S(Z, P, wc, ws, xmin, xmax, ymax*1.2)
	zoom on
	[S1num, S1den, S2num, S2den] = SORT_LATTICE_POLES_LP_S(P);
	
	figure(2)
	PLOT_PZ_S(-S2den, S2den, wc, ws, xmin, xmax, ymax);
	zoom on	
	
	figure(3)
	PLOT_PZ_S(-S1den, S1den, wc, ws, xmin, xmax, ymax);
	zoom on
	omega = linspace(0, 10, 1000); 
	Hodd = PZ_2_FREQ_S(0.5,S1num, S1den, omega);	
	Heven = PZ_2_FREQ_S(0.5, S2num, S2den, omega);
	Att = MAG_2_ATT(Heven-Hodd);	

	figure(4)
	subplot('position', [0.08 0.4 0.90 0.5]); 
	PLOT_ATT_S(omega, Att)
	axis([0, 10, 0, 60]);
	G = 1;
	[Xnum, Xden] = S_2_Z(G, S1num, S1den);
	[L, C, K] = X_CAUER_I(Xnum, Xden)
	[Xnum, Xden] = S_2_Z(G, S2num, S2den);	
	[L, C, K] = X_CAUER_I(Xnum, Xden)
	
	
